﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// Enumerates the types of access that can be requested.
    /// </summary>
    public enum AccessType
    {
        Unspecified = 0,
        WithCode = 1,
        Emergency = 2
    }

    /// <summary>
    /// View model for gaining access to the PCEHR for a selected patient.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
    /// </history>
    public class GainAccessViewModel : PcehrViewModelBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the return URL.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public string ReturnUrl { get; internal set; }

        /// <summary>
        /// Gets or sets the access code entered by the user.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        [Display(Name = "Access Code")]
        public string AccessCode { get; internal set; }

        /// <summary>
        /// Gets or sets the access type selected by the user.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public AccessType AccessType { get; internal set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public GainAccessViewModel()
        {

        }

        #endregion

    }
}

